/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import sun.awt.ScreenUpdater;
import sun.awt.SunToolkit;
import sun.awt.UpdateClient;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WGraphics;
import sun.awt.windows.WImage;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WOffScreenImage;
import sun.awt.windows.WToolkit;

abstract class WComponentPeer
extends WObjectPeer
implements ComponentPeer,
UpdateClient {
    private boolean repaintPending;
    private Rectangle repaintRect;
    private int updateX1;
    private int updateY1;
    private int updateX2;
    private int updateY2;

    public synchronized native void show();

    public synchronized native void hide();

    public synchronized native void enable();

    public synchronized native void disable();

    public native Point getLocationOnScreen();

    public void setVisible(boolean bl) {
        if (bl) {
            this.show();
            return;
        }
        this.hide();
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
            return;
        }
        this.disable();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(((Component)this.target).getForeground());
        graphics.setFont(((Component)this.target).getFont());
        ((Component)this.target).paint(graphics);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.addRepaintArea(n, n2, n3, n4);
        ScreenUpdater.updater.notify(this, l);
    }

    public void print(Graphics graphics) {
        ((WGraphics)graphics).print(this);
    }

    public synchronized native void reshape(int var1, int var2, int var3, int var4);

    public native void handleEvent(AWTEvent var1);

    public Dimension getMinimumSize() {
        return ((Component)this.target).getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public ColorModel getColorModel() {
        return WToolkit.getStaticColorModel();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public Graphics getGraphics() {
        WGraphics wGraphics = new WGraphics(this);
        ((Graphics)wGraphics).setColor(((Component)this.target).getForeground());
        ((Graphics)wGraphics).setFont(((Component)this.target).getFont());
        return wGraphics;
    }

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    public void dispose() {
        WToolkit.targetDisposedPeer(this.target, this);
        ScreenUpdater.updater.removeClient(this);
        this._dispose();
    }

    native void _dispose();

    public synchronized void setForeground(Color color) {
        this._setForeground(color.getRGB());
    }

    public synchronized void setBackground(Color color) {
        this._setBackground(color.getRGB());
    }

    public native void _setForeground(int var1);

    public native void _setBackground(int var1);

    public synchronized native void setFont(Font var1);

    public synchronized native void requestFocus();

    public synchronized native void setCursor(Cursor var1);

    public Image createImage(ImageProducer imageProducer) {
        return new WImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new WOffScreenImage((Component)this.target, n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public void updateClient(Object object) {
        Rectangle rectangle = null;
        WComponentPeer wComponentPeer = this;
        synchronized (wComponentPeer) {
            if (this.repaintPending) {
                rectangle = this.repaintRect;
                this.repaintPending = false;
            }
        }
        if (rectangle != null) {
            this.postEvent(new PaintEvent((Component)this.target, 801, rectangle));
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.target + "]";
    }

    WComponentPeer(Component component) {
        this.target = component;
        this.repaintRect = new Rectangle();
        this.repaintPending = false;
        Container container = SunToolkit.getNativeContainer(component);
        WComponentPeer wComponentPeer = (WComponentPeer)WToolkit.targetToPeer(container);
        this.create(wComponentPeer);
        this.initialize();
        this.start();
    }

    abstract void create(WComponentPeer var1);

    synchronized native void start();

    void initialize() {
        Font font;
        Color color;
        this.initZOrderPosition();
        if (((Component)this.target).isVisible()) {
            this.show();
        }
        if ((color = ((Component)this.target).getForeground()) != null) {
            this.setForeground(color);
        }
        if ((font = ((Component)this.target).getFont()) != null) {
            this.setFont(font);
        }
        if (!((Component)this.target).isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = ((Component)this.target).getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Cursor cursor = ((Component)this.target).getCursor();
        if (cursor != Cursor.getPredefinedCursor(0)) {
            this.setCursor(cursor);
        }
    }

    private synchronized void addRepaintArea(int n, int n2, int n3, int n4) {
        if (!this.repaintPending) {
            this.repaintPending = true;
            this.repaintRect = new Rectangle(n, n2, n3, n4);
            return;
        }
        this.repaintRect = this.repaintRect.union(new Rectangle(n, n2, n3, n4));
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
    }

    void handleExpose(int n, int n2, int n3, int n4) {
        Graphics graphics = this.getGraphics();
        try {
            graphics.clearRect(n, n2, n3, n4);
        }
        catch (NullPointerException nullPointerException) {}
        this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle(n, n2, n3, n4)));
    }

    void handlePaint(int n, int n2, int n3, int n4) {
        this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle(n, n2, n3, n4)));
    }

    void postEvent(AWTEvent aWTEvent) {
        WToolkit.postEvent(aWTEvent);
    }

    protected void finalize() throws Throwable {
        this._dispose();
        super.finalize();
    }

    public void beginValidate() {
        this._beginValidate();
    }

    public native void _beginValidate();

    public native void endValidate();

    public void initZOrderPosition() {
        Container container = ((Component)this.target).getParent();
        WComponentPeer wComponentPeer = null;
        if (container != null) {
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] == this.target) break;
                Object object = WToolkit.targetToPeer(componentArray[n]);
                if (object != null && !(object instanceof LightweightPeer)) {
                    wComponentPeer = (WComponentPeer)object;
                }
                ++n;
            }
        }
        this.setZOrderPosition(wComponentPeer);
    }

    native void setZOrderPosition(WComponentPeer var1);

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }
}

